<?php

namespace App\Http\Resources\Appointment;

use App\Http\Resources\Service\ServiceResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AppointmentListingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'country_code' => $this->country_code,
            'dial_code' => $this->dial_code,
            'booking_date' => $this->booking_date,
            'status' => $this->status,
            "chart_id" => $this->chart_id,
            "chart_json" => $this->chart_json,
            'form_json' => $this->form_json,
            'amount' => $this->amount,
            'description' => "This is description",
            'created_at' => $this->created_at,
            'timeslot' => $this->timeslot,
        ];
    }
}
