<?php

namespace App\Http\Resources\Appointment;

use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\Consultant\InventoryResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\Service\ServiceResource;
use App\Http\Resources\User\ConsultantResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AppointmentDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'country_code' => $this->country_code,
            'dial_code' => $this->dial_code,
            'booking_date' => $this->booking_date,
            'status' => $this->status,
            'amount' => $this->amount,
            'description' => "This is description",
            'report' => $this->report,
            'created_at' => $this->created_at,
            'chat_id' => $this?->chat_id,
            'timeslot' => $this->timeslot,
            "chart_id" => $this->chart_id,
            "chart_json" => $this->chart_json,
            'form_json' => $this->form_json,
            'consultant' => new ConsultantResource($this->consultant),
            'service' => new ServiceResource($this->service),
            'user' => new UserListingResource($this->user),
            'documents' => ImageResource::collection($this->documents),
            'inventories' => InventoryResource::collection($this->inventories)
        ];
    }
}
