<?php

namespace App\Http\Resources\Admin;

use App\Http\Resources\ChartResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ChartSubmissionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "form_json" => $this->form_json,
            "created_at" => $this->created_at->format('d/m/Y'),
            "updated_at" => $this->updated_at->format('d/m/Y'),
            "user" => $this->whenLoaded('user', function () {
                return new UserListingResource($this->user);
            }),
            "chart" => $this->whenLoaded('chart', function () {
                return new ChartResource($this->chart);
            })

        ];
    }
}
