<?php

namespace App\Http\Requests\User;

use Illuminate\Foundation\Http\FormRequest;

class CreateConsultantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => ['required', 'string'],
            'last_name' => ['required', 'string'],
            'email' => ['required', 'email', 'unique:users'],
            'phone' => 'required',
            'password' => 'required',
            'password_confirmation' => 'required|same:password',
            'personal_details' => 'required',
            'licence_no' => 'required',
            'license_expiration' => 'required',
            'license_images' => 'nullable|array',
            'license_images.*' => 'file|mimes:jpg,png|max:10240',
            'attachments' => 'required|array',
            'attachments.*' => 'file|mimes:pdf,docx|max:10240',
        ];
    }
}
