<?php

namespace App\Http\Requests\TimeSlot;

use Illuminate\Foundation\Http\FormRequest;

class ConsultantCreateTimeSlotRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'timeslots' => 'required|array',
            'timeslots.*.day' => 'required|string|in:Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday',
            'timeslots.*.is_enabled' => 'required',
            'timeslots.*.slots' => 'array',
            'timeslots.*.slots.*.time' => [
                'required_if:timeslots.*.is_enabled,true',
                'date_format:H:i',
            ],
            'timeslots.*.slots.*.status' => [
                'required_if:timeslots.*.is_enabled,true',
                'string',
                'in:available,cancelled,booked',
            ],
            'timeslots.*' => function ($attribute, $value, $fail) {
                $isEnabled = filter_var($value['is_enabled'], FILTER_VALIDATE_BOOLEAN);
                if ($isEnabled && empty($value['slots'])) {
                    $fail("At least one slot must be provided for the day: {$value['day']} when is_enabled is true.");
                }
            },
        ];
    }
}


