<?php

namespace App\Http\Requests\Service;

use Illuminate\Foundation\Http\FormRequest;

class UpdateServiceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title' => 'required|string|max:255', // Title should be a string and can be max 255 characters
            'description' => 'required|string', // Description should be a string and allows typical text characters (including punctuation marks)
            'charges' => 'required|numeric|regex:/^\d+(\.\d{1,2})?$/', // Charges should be a float (allowing 2 decimal places)
            'status' => 'required|in:1,0', // Status should be either 'active' or 'inactive'
            'service_category_id' => 'required|exists:service_categories,id', // Service category ID must exist in the service_categories table
            'images' => 'nullable|array', // Ensure 'files' is an array
            'images.*' => 'file|mimes:jpg,png,pdf,docx|max:10240', // Each file should be a valid file and meet the mime and max size constraints
            'consultant_ids' => 'required|array', // An array of user IDs
            'consultant_ids.*' => 'integer|exists:users,id', // Each user ID in the array must be an integer and exist in the users table
        ];
    }
}
