<?php

namespace App\Http\Requests\Chat;

use Illuminate\Foundation\Http\FormRequest;


class SendMessageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'chat_id' => 'required|exists:chats,id',
            'message' => [
                'nullable', // Allows the message to be empty
                'string', // Ensure `message` is a string if it is present
                'required_without:file', // The field is required if `file` is not present
            ],
            'file' => [
                'sometimes', // The field will be validated if present
                'file', // Validate as a file
                'mimes:jpeg,png,jpg,gif,mp4,mov,avi,mkv', // Allow specific image and video formats
                'max:2048', // Limit file size to 2MB
            ],
        ];
    }
}
