<?php

namespace App\Http\Requests\Chat;

use Illuminate\Foundation\Http\FormRequest;

class CreateGroupChatRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        // Authorization logic here, e.g., check if the user is authenticated
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255', // The name of the group chat
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            'users' => 'required|array', // The members field should be an array
            'users.*' => 'integer|exists:users,id', // Each member ID should be an integer and exist in the users table
        ];
    }
}
