<?php

namespace App\Http\Requests\Appointment;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAppointmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'report' => 'nullable|string',
            'inventory' => 'nullable|array',
            'inventory.*.quantity' => 'required|numeric|min:0',
            'inventory.*.category_id' => 'required|exists:categories,id',
            'inventory.*.sub_category_id' => 'required|exists:sub_categories,id',
        ];
    }
}
