<?php

namespace App\Http\Requests\Appointment;

use Illuminate\Foundation\Http\FormRequest;

class CreateAppointmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'country_code' => 'required',
            'dial_code' => 'required',
            'service_id' => 'required|exists:services,id',
            'consultant_id' => 'required|exists:users,id',
            'date' => 'required|date|date_format:Y-m-d',
            'time' => 'required|date_format:H:i',
        ];
    }
}
