<?php

namespace App\Http\Controllers;

use App\Http\Controllers\MainApiController;
use App\Http\Resources\NotificationResource;
use Illuminate\Http\Request;
use App\Services\NotificationService;


class NotificationController extends MainApiController
{
    public function index(NotificationService $notificationService)
    {
        $data = $notificationService->index();
        return $this->response->success(
            $data
        );
    }

    public function mark(Request $request, NotificationService $notificationService)
    {
        $data = $notificationService->mark();
        return $this->response->success(
            $data
        );
    }

    public function unread(NotificationService $notificationService)
    {
        $data = $notificationService->unread();
        return $this->response->success(
            $data
        );
    }
    public function read(NotificationService $notificationService)
    {
        $data = $notificationService->read();
        return $this->response->success(
            $data
        );
    }

    public function markAsUnread(Request $request)
    {
        $notification = auth()->user()->notifications()->where('id', $request->uuid)->get();
        return $notification->markAsUnread();
    }

    public function individual(Request $request)
    {
        $notification = auth()->user()->notifications()->where('id', $request->uuid)->get();
        $notification->markAsRead();
        return $this->response->success(
            NotificationResource::collection(
                $notification
            )
        );

    }

    public function unreadNotificationCount()
    {
        return response()->json(["count" => auth()->user()->unreadNotifications()->count()], 200);
    }

    public function unreadMessageCount()
    {
        return response()->json(["count" => auth()->user()->unreadNotifications()->whereRaw('JSON_CONTAINS(`data`, \'{"data": {"type": "message"}}\')')->count()], 200);
    }
}
