<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Category\SubCategoryResource;
use App\Services\SubCategoryService;
use Illuminate\Http\Request;

class SubCategoryController extends MainApiController
{

    private $subCategoryService;
    public function __construct(SubCategoryService $subCategoryService)
    {
        parent::__construct();
        $this->subCategoryService = $subCategoryService;
    }
    public function list($id)
    {
        $categorys = $this->subCategoryService->listActiveWithoutPaginationWithrespectToCategory($id);
        return $this->response->success(
            SubCategoryResource::collection($categorys)
        );
    }
}
