<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Service\ServiceDetailResource;
use App\Http\Resources\Service\ServiceResource;
use App\Services\ServiceService;
use Illuminate\Http\Request;

class ServiceController extends MainApiController
{
    private $serviceService;
    public function __construct(ServiceService $serviceService)
    {
        parent::__construct();
        $this->serviceService = $serviceService;
    }
    public function show($id)
    {
        $service = $this->serviceService->show($id);
        return $this->response->success(
            new ServiceDetailResource($service)
        );
    }
    public function consultantServices()
    {
        $services = $this->serviceService->consultantServices(auth()->user()->id);
        return $this->response->success(
            resource: ServiceResource::collection($services)
        );
    }
}
