<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Report\CreateReportRequest;
use App\Http\Resources\ReportResource;
use App\Services\ReportService;
use Illuminate\Http\Request;

class ReportController extends MainApiController
{
    public function store(CreateReportRequest $request, ReportService $reportService)
    {
        $report = $reportService->reportChat($request);
        return $this->response->success(
            new ReportResource($report)
        );
    }
}
