<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\DefaultResource;
use App\Models\Appointment;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class HomeController extends MainApiController
{
    public function dashboardStats(Request $request)
    {
        $currentYear = request("year");
        $totalUsers = User::where('type', 'user')->count();
        $totalEarnings = Appointment::where("consultant_id", auth()->user()->id)->count();
        $monthsCountEarnings = array_fill(0, 12, 0);
        for ($month = 1; $month <= Carbon::now()->month; $month++) {
            $startOfMonth = Carbon::create($currentYear, $month, 1)->startOfMonth();
            $endOfMonth = Carbon::create($currentYear, $month, 1)->endOfMonth();
            $totalEarningsMonthly = Appointment::where("consultant_id", auth()->user()->id)->whereBetween('created_at', [$startOfMonth, $endOfMonth])
                ->get()
                ->sum(function ($appointment) {
                    return $appointment->amount;
                });
            $monthsCountEarnings[$month - 1] = $totalEarningsMonthly;
        }
        $data = [
            'status' => true,
            'total_users' => $totalUsers,
            'total_bookings' => $totalEarnings,
            'monthly_earnings' => $monthsCountEarnings,
        ];
        return $this->response->success(
            new DefaultResource(['data' => $data])
        );
    }
}
