<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\TimeSlot\ConsultantCreateTimeSlotRequest;
use App\Http\Requests\TimeSlot\GetTimeSlotByDateAndConsultantIdRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\User\ConsultantResource;
use App\Http\Resources\User\ConsultantWithRatingResource;
use App\Http\Resources\User\UserWithRatingDetailsResource;
use App\Services\ConsultantService;
use App\Services\TimeSlotService;
use Illuminate\Http\Request;

class ConsultantController extends MainApiController
{
    private $consultantService;

    public function __construct(ConsultantService $consultantService)
    {
        parent::__construct();
        $this->consultantService = $consultantService;
    }
    public function consultantReviews()
    {
        $user = $this->consultantService->consultantReviews(auth()->user()->id);
        return $this->response->success(
            new ConsultantWithRatingResource($user)
        );
    }
    public function ServiceConsultants($serviveId)
    {
        $consultants = $this->consultantService->serviceConsultatnts($serviveId);
        return $this->response->success(
            ConsultantWithRatingResource::collection($consultants)
        );
    }

    public function consultantTimeslot(TimeSlotService $timeSlotService)
    {
        $timeSlots = $timeSlotService->getConsultantTimeslotsByWeek(auth()->user()->id);
        return $this->response->success(
            $timeSlots
        );
    }

    public function updateTimeslots(ConsultantCreateTimeSlotRequest $request, TimeSlotService $timeSlotService)
    {
        $payload = (object) [
            'consultant_id' => auth()->id(),
            'timeslots' => $request->input('timeslots', []),
        ];

        $message = $timeSlotService->create($payload);

        return $this->response->successMessage($message);
    }

    public function getAvailableEvents(TimeSlotService $timeSlotService, $consultant_id)
    {
        $timeSlots = $timeSlotService->getAvailableEvents($consultant_id, );
        return $this->response->success(
            DefaultResource::collection($timeSlots)
        );
    }
}
