<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Category\CategoryResource;
use App\Services\CategoryService;
use Illuminate\Http\Request;

class CategoryController extends MainApiController
{
    private $categoryService;
    public function __construct(CategoryService $categoryService)
    {
        parent::__construct();
        $this->categoryService = $categoryService;
    }
    public function list()
    {
        $categorys = $this->categoryService->listActiveWithoutPagination();
        return $this->response->success(
            CategoryResource::collection($categorys)
        );
    }
}
