<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\User\LoginRequest;
use App\Http\Requests\User\UserProfileUpdateRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\User\ConsultantResource;
use App\Models\Image;
use App\Services\Common\UserService;
use Auth;
use Illuminate\Http\Request;

class AuthController extends MainApiController
{
    public function login(LoginRequest $request, UserService $userService)
    {
        $data = $userService->checkLogin($request, 'consultant');
        return $this->response->success(
            $data
        );
    }

    public function logout(Request $request)
    {
        $user = Auth::user();
        $user->tokens()->where('id', $user->currentAccessToken()->id)->delete();
        return response()->json(['status' => true, 'message' => 'Logout Successful']);
    }

    public function update(Request $request, UserService $userService)
    {
        $user = $userService->updateConsultant($request, auth()->user()->id);
        return $this->response->success(
            new ConsultantResource($user)
        );
    }

    public function deleteImage(Image $image, UserService $userService)
    {
        $userService->deleteImage($image);
        return $this->response->success(
            new DefaultResource(['message' => "Image Deleted"])
        );
    }

    public function profile(Request $request)
    {
        $user = auth()->guard()->user(); //->load(['education', 'skills', 'experience']);
        return $this->response->success(
            new ConsultantResource($user)
        );
    }
}
