<?php

namespace App\Http\Controllers\Consultant;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Appointment\UpdateAppointmentRequest;
use App\Http\Resources\Appointment\AppointmentDetailsResource;
use App\Http\Resources\Appointment\AppointmentListingResource;
use App\Services\AppointmentService;
use App\Services\ChatService;
use Illuminate\Http\Request;

class AppointmentController extends MainApiController
{
    protected $appointmentService;

    public function __construct(AppointmentService $appointmentService)
    {
        parent::__construct();
        $this->appointmentService = $appointmentService;
    }
    public function index()
    {
        $appointment = $this->appointmentService->consultantAppointment(auth()->user()->id);
        return $this->response->success(
            AppointmentListingResource::collection($appointment)
        );
    }

    public function view($id, ChatService $chatService)
    {
        $appointment = $this->appointmentService->view($id);
        $chat = $chatService->getChatIfExists($appointment->user_id, $appointment->consultant_id);
        $appointment->chat_id = $chat?->id;
        return $this->response->success(
            new AppointmentDetailsResource($appointment)
        );
    }
    public function update(UpdateAppointmentRequest $request, $id)
    {
        $appointment = $this->appointmentService->update($request, $id);
        return $this->response->success(
            new AppointmentDetailsResource($appointment)
        );
    }
}
