<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Subscription\CreateSubscriptionRequest;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\User\UserSubscriptionResource;
use App\Services\UserSubscriptionService;
use Illuminate\Http\Request;
use Stripe\Service\SubscriptionService;

class SubscriptionController extends MainApiController
{
    private $userSubscriptionService;
    public function __construct(UserSubscriptionService $userSubscriptionService)
    {
        parent::__construct();
        $this->userSubscriptionService = $userSubscriptionService;
    }

    public function store(CreateSubscriptionRequest $request)
    {
        return $this->userSubscriptionService->createCheckoutSession(auth()->user()->id, $request->plan_id);
    }

    public function success(Request $request)
    {
        return $this->userSubscriptionService->handleCheckoutSessionSuccess($request);
    }

    public function cancel()
    {
        return $this->userSubscriptionService->cancelSubscription(auth()->user()->id);
    }

    public function userSubscription()
    {
        $subscriptions = $this->userSubscriptionService->userSubscriptions(auth()->user()->id);
        $currentSubscription = $this->userSubscriptionService->userCurrentSubscription(auth()->user()->id);

        return $this->response->success(
            new DefaultResource([
                'current' => new UserSubscriptionResource($currentSubscription),
                'past' => UserSubscriptionResource::collection($subscriptions)
            ])
        );
    }
}
