<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\FirebaseService;
use App\Services\StripeService;
use Illuminate\Http\Request;

class StripeController extends Controller
{
    public function success(Request $request, StripeService $stripeService)
    {
        return $stripeService->success($request);
    }

    public function cancel(StripeService $stripeService)
    {
        return $stripeService->cancel();
    }

    public function checkPushNotification(Request $request, FirebaseService $firebaseService)
    {
        // $token = 'cTQXuMKIRUm1mBVS5FnJja:APA91bFAFPc9TX9LzKKzsaqgUW5GoQL3cQwtCzarNkmr3aSHSwaAg_ALRjSKoE6iivvR1rbfQN3pcNvbrUoRh9GnHO6Xkpt0_Y8EfedmcYD6liNMd1ywfk4';
        $token = $request->token;
        if ($token) {
            $firebaseService->sendNotification($token, 'Payment Successful', 'Booking Payment Successful');
        }

        return response()->json(['message' => 'notification sent']);
    }
}
