<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Service\ServiceResource;
use App\Services\ServiceService;
use Illuminate\Http\Request;

class ServiceController extends MainApiController
{
    private $serviceService;
    public function __construct(ServiceService $serviceService)
    {
        parent::__construct();
        $this->serviceService = $serviceService;
    }

    public function index()
    {
        $services = $this->serviceService->activeServices();
        return $this->response->success(
            ServiceResource::collection($services)
        );
    }

    public function show($id)
    {
        $service = $this->serviceService->show($id);
        return $this->response->success(
            new ServiceResource($service)
        );
    }

    public function consultantServices($consultant_id)
    {
        $services = $this->serviceService->consultantServices($consultant_id);
        return $this->response->success(
            resource: ServiceResource::collection($services)
        );
    }

    public function categoryServices($category_id)
    {
        $services = $this->serviceService->categoryServices($category_id);
        return $this->response->success(
            resource: ServiceResource::collection($services)
        );
    }

}
