<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\ServiceCategory\ServiceCategoryResource;
use App\Http\Resources\ServiceCategory\ServiceCategoryWithServiceResource;
use App\Services\ServiceCategoryService;
use Illuminate\Http\Request;

class ServiceCategoryController extends MainApiController
{
    protected $serviceCategoryService;

    public function __construct(ServiceCategoryService $serviceCategoryService)
    {
        $this->serviceCategoryService = $serviceCategoryService;
        parent::__construct();
    }

    public function index(Request $request)
    {
        $serviceCategories = $this->serviceCategoryService->active();
        return $this->response->success(
            ServiceCategoryResource::collection($serviceCategories)
        );
    }

    public function consultantServiceCategories($id)
    {
        $serviceCategories = $this->serviceCategoryService->consultantServiceCategories($id);
        return $this->response->success(
            ServiceCategoryWithServiceResource::collection($serviceCategories)
        );
    }
}
