<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Rating\AddRatingRequest;
use App\Http\Resources\DefaultResource;
use App\Services\RatingService;
use Illuminate\Http\Request;

class RatingController extends MainApiController
{
    private $ratingService;

    public function __construct(RatingService $ratingService)
    {
        parent::__construct();
        $this->ratingService = $ratingService;
    }

    public function store(AddRatingRequest $request)
    {
        $checkRating = $this->ratingService->checkRating($request->consultant_id, auth()->user()->id);
        if (!$checkRating) {
            $rating = $this->ratingService->store($request);
        } else {
            $rating = $this->ratingService->update($request, $checkRating->id);
        }
        return $this->response->success(
            new DefaultResource($rating)
        );
    }
}
