<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Plan\PlanResource;
use App\Services\PlanService;
use Illuminate\Http\Request;

class PlanController extends MainApiController
{
    private $planService;
    public function __construct(PlanService $planService)
    {
        parent::__construct();
        $this->planService = $planService;
    }
    public function listActive()
    {
        $plans = $this->planService->listActive();
        return $this->response->success(
            PlanResource::collection($plans)
        );
    }
}
