<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\PaymentLog\PaymentLogResource;
use App\Services\PaymentLogService;
use Illuminate\Http\Request;

class PaymentLogController extends MainApiController
{
    protected $paymentLogService;
    public function __construct(PaymentLogService $paymentLogService)
    {
        $this->paymentLogService = $paymentLogService;
        parent::__construct();
    }

    public function index(Request $request)
    {
        $paymentLogs = $this->paymentLogService->userPaymentLogs(auth()->user()->id);
        return $this->response->success(
            PaymentLogResource::collection($paymentLogs)
        );
    }

}
