<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\User\UserWithRatingListingResource;
use App\Http\Resources\User\UserWithServicesListingResource;
use App\Services\ConsultantService;
use App\Services\HomeService;
use Illuminate\Http\Request;

class HomeController extends MainApiController
{
    private $homeService;

    public function __construct(HomeService $homeService)
    {
        parent::__construct();
        $this->homeService = $homeService;
    }

    public function index(Request $request)
    {
        $data = $this->homeService->userHome($request);
        return $this->response->success(
            new DefaultResource($data)
        );
    }

   
}
