<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\MainApiController;
use App\Http\Resources\DefaultResource;
use App\Models\Feedback;
use App\Models\User;
use Illuminate\Http\Request;

class FeedbackController extends MainApiController
{
    public function store(Request $request)
    {
        $interestedIn = $request->input('interested_in', []);

        $feedback = Feedback::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'subject' => $request->subject,
            'message' => $request->message,
            'type' => $request->type,
            'interested_in' => $interestedIn,
            'botox_party' => in_array('Botox Party', $interestedIn) ? 'yes' : 'no',
        ]);

        $title = $request->first_name.' '.$request->last_name.' submitted a query!';
        $body = $request->subject;
        $data = [
            'user' => $request->all(),
            'title' => $title,
            'body' => $body,
        ];

        $admin = User::where('type', 'admin')->first();
        sendNotification($title, $body, $data, $admin->id, $admin);

        return $this->response->success(
            new DefaultResource($feedback)
        );
    }

    public function show(Request $request, Feedback $feedback)
    {
        $feedback = $feedback->load('user');

        return $this->response->success(
            new DefaultResource(['feedback' => $feedback])
        );
    }
}
