<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\TimeSlot\GetTimeSlotByDateAndConsultantIdRequest;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\Rating\RatingResource;
use App\Http\Resources\User\ConsultantResource;
use App\Http\Resources\User\UserWithRatingDetailsResource;
use App\Http\Resources\User\ConsultantWithRatingResource;
use App\Services\ConsultantService;
use App\Services\TimeSlotService;
use Request;

class ConsultantController extends MainApiController
{
    private $consultantService;

    public function __construct(ConsultantService $consultantService)
    {
        parent::__construct();
        $this->consultantService = $consultantService;
    }
    public function consultants()
    {
        $consultants = $this->consultantService->activeConsultants();
        return $this->response->success(
            ConsultantWithRatingResource::collection($consultants)
        );
    }

    public function consultant($id)
    {
        $consultant = $this->consultantService->consultant($id);
        return $this->response->success(
            new ConsultantWithRatingResource($consultant)
        );
    }

    public function consultantReviews($id)
    {
        $user = $this->consultantService->consultantReviews($id);
        $ratings = $this->consultantService->consultantReviewsOnly($id);

        return $this->response->success(
            new DefaultResource([
                "user" => new UserWithRatingDetailsResource($user),
                "ratings" => RatingResource::collection($ratings), // keeps data
                "meta" => [
                    "current_page" => $ratings->currentPage(),
                    "from" => $ratings->firstItem(),
                    "last_page" => $ratings->lastPage(),
                    "links" => $ratings->linkCollection(), // Laravel >= 9
                    "path" => $ratings->url(1),
                    "per_page" => $ratings->perPage(),
                    "to" => $ratings->lastItem(),
                    "total" => $ratings->total(),
                ],
                "links" => [
                    "first" => $ratings->url(1),
                    "last" => $ratings->url($ratings->lastPage()),
                    "prev" => $ratings->previousPageUrl(),
                    "next" => $ratings->nextPageUrl(),
                ],
            ])
        );
    }
    public function ServiceConsultants($serviveId)
    {
        $consultants = $this->consultantService->serviceConsultatnts($serviveId);
        return $this->response->success(
            ConsultantWithRatingResource::collection($consultants)
        );
    }

    public function consultantTimeslot(GetTimeSlotByDateAndConsultantIdRequest $request, TimeSlotService $timeSlotService)
    {
        $timeSlots = $timeSlotService->getConsultantTimeslotsByDate($request->consultant_id, $request->date);
        return $this->response->success(
            DefaultResource::collection($timeSlots)
        );
    }

    public function getAvailableEvents(TimeSlotService $timeSlotService, $consultant_id)
    {
        $timeSlots = $timeSlotService->getAvailableEvents($consultant_id, );
        return $this->response->success(
            DefaultResource::collection($timeSlots)
        );
    }
}
