<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\TimeSlot\CreateTimeSlotRequest;
use App\Http\Resources\DefaultResource;
use App\Services\TimeSlotService;
use Request;


class TimeSlotController extends MainApiController
{
    protected $timeSlotService;

    public function __construct(TimeSlotService $timeSlotService)
    {
        $this->timeSlotService = $timeSlotService;
        parent::__construct();
    }

    public function create(CreateTimeSlotRequest $request)
    {
        $service = $this->timeSlotService->create($request);
        return $this->response->successMessage(
            $service
        );
    }

    public function copyLastWeekSlotsToCurrentWeek(Request $request, $id)
    {
        $service = $this->timeSlotService->copyCurrentWeekSlotsToNextWeek($id);
        return $this->response->successMessage(
            $service
        );
    }

    public function consultantTimeslot($id)
    {
        $timeSlots = $this->timeSlotService->getConsultantTimeslotsByWeek($id);
        return $this->response->success(
            $timeSlots
        );
    }

    public function getTimeSlots($id)
    {
        $response = $this->timeSlotService->getTimeSlots($id);
        return $this->response->success(
            DefaultResource::collection($response)
        );
    }

    public function getWeeklyTimeSlots($id)
    {
        $response = $this->timeSlotService->getWeekRanges($id);
        return $response;
        return $this->response->success(
            new DefaultResource($response)
        );
    }
}
