<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\Category\CreateSubCategoryRequest;
use App\Http\Requests\Category\UpdateSubCategoryRequest;
use App\Http\Resources\Appointment\AppointmentListingResource;
use App\Http\Resources\Category\SubCategoryResource;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\User\ConsultantResource;
use App\Models\SubCategory;
use App\Services\SubCategoryService;

class SubCategoryController extends MainApiController
{
    private $subCategoryService;
    public function __construct(SubCategoryService $subCategoryService)
    {
        parent::__construct();
        $this->subCategoryService = $subCategoryService;
    }
    public function create(CreateSubCategoryRequest $request)
    {
        $category = $this->subCategoryService->create($request);
        return $this->response->success(
            new SubCategoryResource($category)
        );
    }
    public function update($id, UpdateSubCategoryRequest $request)
    {
        $category = $this->subCategoryService->update($id, $request);
        return $this->response->success(
            new SubCategoryResource($category)
        );
    }
    public function delete($id)
    {
        $category = $this->subCategoryService->delete($id);
        return $this->response->success(
            new SubCategoryResource($category)
        );
    }
    public function view(SubCategory $subCategory)
    {
        return $this->response->success(
            new SubCategoryResource($subCategory)
        );
    }
    public function list()
    {
        $categorys = $this->subCategoryService->list();
        return $this->response->success(
            SubCategoryResource::collection($categorys)
        );
    }
    public function status($id)
    {
        $category = $this->subCategoryService->status($id);
        return $this->response->success(
            new SubCategoryResource($category)
        );
    }
    public function consultants($id)
    {
        $consultants = $this->subCategoryService->consultants($id);
        return $this->response->success(
            ConsultantResource::collection($consultants)
        );
    }
    public function details($id, $user_id)
    {
        $data = $this->subCategoryService->details($id, $user_id);

        return $this->response->success(
            new DefaultResource([
                "total_quantity" => $data["total_quantity"],
                "total_bookings" => $data["total_bookings"],
                "appointments" => AppointmentListingResource::collection($data["appointments"]),
                "meta" => [
                    "current_page" => $data["appointments"]->currentPage(),
                    "from" => $data["appointments"]->firstItem(),
                    "last_page" => $data["appointments"]->lastPage(),
                    "links" => $data["appointments"]->linkCollection(),
                    "path" => $data["appointments"]->url(1),
                    "per_page" => $data["appointments"]->perPage(),
                    "to" => $data["appointments"]->lastItem(),
                    "total" => $data["appointments"]->total(),
                ],
                "links" => [
                    "first" => $data["appointments"]->url(1),
                    "last" => $data["appointments"]->url($data["appointments"]->lastPage()),
                    "prev" => $data["appointments"]->previousPageUrl(),
                    "next" => $data["appointments"]->nextPageUrl(),
                ],
            ])
        );
    }
}
