<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\ServiceCategory\CreateServiceCategoryRequest;
use App\Http\Requests\ServiceCategory\UpdateServiceCategoryRequest;
use App\Http\Resources\ServiceCategory\ServiceCategoryResource;
use App\Models\ServiceCategory;
use App\Services\ServiceCategoryService;
use Illuminate\Http\Request;

class ServiceCategoryController extends MainApiController
{
    protected $serviceCategoryService;

    public function __construct(ServiceCategoryService $serviceCategoryService)
    {
        $this->serviceCategoryService = $serviceCategoryService;
        parent::__construct();
    }

    public function index(Request $request)
    {
        $serviceCategories = $this->serviceCategoryService->index();
        return $this->response->success(
            ServiceCategoryResource::collection($serviceCategories)
        );
    }

    public function active()
    {
        $serviceCategories = $this->serviceCategoryService->active();
        return $this->response->success(
            ServiceCategoryResource::collection($serviceCategories)
        );
    }

    public function create(CreateServiceCategoryRequest $request)
    {
        $serviceCategory = $this->serviceCategoryService->create($request);
        return $this->response->success(
            new ServiceCategoryResource($serviceCategory)
        );
    }

    public function show($id)
    {
        $serviceCategory = $this->serviceCategoryService->show($id);
        return $this->response->success(
            new ServiceCategoryResource($serviceCategory)
        );
    }

    public function status($id)
    {
        $serviceCategory = $this->serviceCategoryService->accountStatus($id);
        return $this->response->success(
            new ServiceCategoryResource($serviceCategory)
        );
    }

    public function update(UpdateServiceCategoryRequest $request, $id)
    {
        $serviceCategory = $this->serviceCategoryService->update($request, $id);
        return $this->response->success(
            new ServiceCategoryResource($serviceCategory)
        );
    }

    public function delete($id)
    {
        $serviceCategory = $this->serviceCategoryService->delete($id);
        return $this->response->success(
            new ServiceCategoryResource($serviceCategory)
        );
    }
}
