<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Plan\CreatePlanRequest;
use App\Http\Requests\Plan\UpdatePlanRequest;
use App\Http\Resources\Plan\PlanResource;
use App\Models\Plan;
use App\Services\PlanService;
use Illuminate\Http\Request;

class PlanController extends MainApiController
{
    private $planService;
    public function __construct(PlanService $planService)
    {
        parent::__construct();
        $this->planService = $planService;
    }
    public function create(CreatePlanRequest $request)
    {
        $plan = $this->planService->create($request);
        return $this->response->success(
            new PlanResource($plan)
        );
    }
    public function update($id, UpdatePlanRequest $request)
    {
        $plan = $this->planService->update($id, $request);
        return $this->response->success(
            new PlanResource($plan)
        );
    }
    public function delete($id)
    {
        $plan = $this->planService->delete($id);
        return $this->response->success(
            new PlanResource($plan)
        );
    }
    public function view(Plan $plan)
    {
        return $this->response->success(
            new PlanResource($plan)
        );
    }
    public function list()
    {
        $plans = $this->planService->list();
        return $this->response->success(
            PlanResource::collection($plans)
        );
    }

    public function status($id)
    {
        $plan = $this->planService->status($id);
        return $this->response->success(
            new PlanResource($plan)
        );
    }
}
