<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Resources\DefaultResource;
use App\Http\Resources\PaymentLog\PaymentLogResource;
use App\Http\Resources\User\UserSubscriptionResource;
use App\Services\PaymentLogService;
use Illuminate\Http\Request;

class PaymentLogController extends MainApiController
{
    protected $paymentLogService;
    public function __construct(PaymentLogService $paymentLogService)
    {
        $this->paymentLogService = $paymentLogService;
        parent::__construct();
    }

    public function index(Request $request)
    {
        $paymentLogs = $this->paymentLogService->index();
        return $this->response->success(
            PaymentLogResource::collection($paymentLogs)
        );
    }
    public function subscriptions(Request $request)
    {
        $paymentLogs = $this->paymentLogService->subscriptions();
        return $this->response->success(
            UserSubscriptionResource::collection($paymentLogs)
        );
    }
}
