<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\DefaultResource;
use App\Services\ImageService;
use Illuminate\Http\Request;

class ImageController extends MainApiController
{
    protected $imageService;
    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
        parent::__construct();
    }
    public function delete($id)
    {
        $message = $this->imageService->delete($id);
        return $this->response->success(
            new DefaultResource(['message' => $message])
        );
    }
}
