<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\MainApiController;
use App\Http\Requests\User\CreateConsultantRequest;
use App\Http\Requests\User\UserRegisterRequest;
use App\Http\Resources\Admin\UserListingResource;
use App\Http\Resources\User\ConsultantResource;
use App\Http\Resources\User\ConsultantWithRatingResource;
use App\Models\User;
use App\Notifications\SendConsultantCredentials;
use App\Services\Common\UserService;
use App\Services\ConsultantService;
use Illuminate\Http\Request;

class ConsultantController extends MainApiController
{
    protected $consultantService;
    public function __construct(ConsultantService $consultantService)
    {
        $this->consultantService = $consultantService;
        parent::__construct();
    }

    public function index(Request $request)
    {
        $users = $this->consultantService->index();
        return $this->response->success(
            ConsultantResource::collection($users)
        );
    }
    public function activeWithPagination(Request $request)
    {
        $users = $this->consultantService->activeWithPagination();
        return $this->response->success(
            ConsultantResource::collection($users)
        );
    }

    public function active()
    {
        $users = $this->consultantService->active();
        return $this->response->success(
            ConsultantResource::collection($users)
        );
    }

    public function create(CreateConsultantRequest $request, UserService $userService)
    {
        $user = $userService->createConsultant($request);
        $user->notify(new SendConsultantCredentials($user, $request->password));
        return $this->response->success(
            new ConsultantResource($user)
        );
    }

    public function updateImage(Request $request, UserService $userService)
    {
        $user = $userService->updateImage($request);
        return $this->response->success(
            new ConsultantResource($user)
        );
    }

    public function show(User $user)
    {
        $user = $this->consultantService->show($user->id);
        return $this->response->success(
            new ConsultantResource($user)
        );
    }

    public function ratings($id)
    {
        $user = $this->consultantService->showWithRatings($id);
        return $this->response->success(
            new ConsultantWithRatingResource($user)
        );
    }

    public function status(User $user, )
    {
        $data = $this->consultantService->accountStatus($user->id);
        return $this->response->success(
            new ConsultantResource($data)
        );
    }

    public function delete(User $user)
    {
        $this->consultantService->delete($user->id);

        return $this->response->success([
            'message' => 'Consultant deleted successfully',
        ]);
    }
}
