<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\MainApiController;
use App\Http\Requests\Admin\SubmitChartRequest;
use App\Http\Requests\ChartRequest;
use App\Http\Resources\Admin\ChartSubmissionResource;
use App\Http\Resources\ChartResource;
use App\Models\Chart;
use App\Services\ChartService;


class ChartController extends MainApiController
{
    private $chartService;
    public function __construct(ChartService $chartService)
    {
        parent::__construct();
        $this->chartService = $chartService;
    }

    public function create(ChartRequest $request)
    {

        $response = $this->chartService->create($request);

        return $this->response->success(
            new ChartResource($response)
        );
    }

    public function update(ChartRequest $request, Chart $chart)
    {


        $response = $this->chartService->update($request, $chart);

        return $this->response->success(
            new ChartResource($response)
        );
    }

    public function submitChart(SubmitChartRequest $request)
    {

        $response = $this->chartService->submitChart($request);

        return $this->response->success(
            new ChartSubmissionResource($response)
        );
    }


    public function index(Request $request)
    {

        $charts = $this->chartService->index($this->pagination);
        return $this->response->success(
            ChartResource::collection($charts)
        );
    }

    public function dropdownChart(Request $request)
    {

        $charts = Chart::get();
        // return $charts;
        return $this->response->success(
            ChartResource::collection($charts)
        );
    }


    public function show(Chart $chart)
    {
        return $this->response->success(
            new ChartResource($chart)
        );
    }
}
