<?php

namespace App\Http\Controllers\Admin;


use App\Http\Controllers\MainApiController;
use App\Http\Requests\Category\CreateCategoryRequest;
use App\Http\Requests\Category\UpdateCategoryRequest;
use App\Http\Resources\Category\CategoryResource;
use App\Models\Category;
use App\Services\CategoryService;

class CategoryController extends MainApiController
{
    private $categoryService;
    public function __construct(CategoryService $categoryService)
    {
        parent::__construct();
        $this->categoryService = $categoryService;
    }
    public function create(CreateCategoryRequest $request)
    {
        $category = $this->categoryService->create($request);
        return $this->response->success(
            new CategoryResource($category)
        );
    }
    public function update($id, UpdateCategoryRequest $request)
    {
        $category = $this->categoryService->update($id, $request);
        return $this->response->success(
            new CategoryResource($category)
        );
    }
    public function delete($id)
    {
        $category = $this->categoryService->delete($id);
        return $this->response->success(
            new CategoryResource($category)
        );
    }
    public function view(Category $category)
    {
        return $this->response->success(
            new CategoryResource($category)
        );
    }
    public function list()
    {
        $categorys = $this->categoryService->list();
        return $this->response->success(
            CategoryResource::collection($categorys)
        );
    }

    public function activelistWithoutPagination()
    {
        $categorys = $this->categoryService->listActiveWithoutPagination();
        return $this->response->success(
            CategoryResource::collection($categorys)
        );
    }

    public function status($id)
    {
        $category = $this->categoryService->status($id);
        return $this->response->success(
            new CategoryResource($category)
        );
    }
}
