<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\MainApiController;
use App\Http\Resources\Appointment\AppointmentDetailsResource;
use App\Http\Resources\Appointment\AppointmentListingResource;
use App\Models\Appointment;
use App\Services\AppointmentService;
use Illuminate\Http\Request;

class AppointmentController extends MainApiController
{
    protected $appointmentService;

    public function __construct(AppointmentService $appointmentService)
    {
        parent::__construct();
        $this->appointmentService = $appointmentService;
    }

    public function index()
    {
        $appointment = $this->appointmentService->adminAppointments();
        return $this->response->success(
            AppointmentDetailsResource::collection($appointment)
        );
    }

    public function show(Appointment $appointment)
    {
        return $this->response->success(
            new AppointmentDetailsResource($appointment)
        );
    }
    public function userAppointment($userId)
    {
        $appointment = $this->appointmentService->userAppointment($userId);
        return $this->response->success(
            AppointmentDetailsResource::collection($appointment)
        );
    }
    public function consultantAppointment($consultantId)
    {
        $appointment = $this->appointmentService->consultantAppointment($consultantId);
        return $this->response->success(
            AppointmentDetailsResource::collection($appointment)
        );
    }
}
